% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{insertResults}
\alias{insertResults}
\title{Insert results}
\usage{
insertResults(db, experimentName, regulatorName, figurePath, loglikelihoods,
  baselineloglikelihoods = NA, experimentDesc = "", loopVariable = 2,
  modelTranslation = FALSE, numberOfParameters = NA, parameterNames = NA,
  experimentProducer = "", experimentTimestamp = "", parameters = NA)
}
\arguments{
\item{db}{Database object created by \code{\link{initializeDb}}}

\item{experimentName}{Experiment name}

\item{regulatorName}{Regulator name (more detailed experiment identifier)}

\item{figurePath}{URL path to figures}

\item{loglikelihoods}{A vector of log-likelihoods of elements identified by names}

\item{baselineloglikelihoods}{A vector of baseline log-likelihoods of elements identified by names (optional)}

\item{experimentDesc}{Optional experiment description}

\item{loopVariable}{Optional: Loop variable (1=regulator, 2=target (default))}

\item{modelTranslation}{Optional: For gene regulation models, is translation modelled}

\item{numberOfParameters}{Optional: Number of parameters}

\item{parameterNames}{Optional: Parameter names}

\item{experimentProducer}{Optional: Experiment producer (string)}

\item{experimentTimestamp}{Optional: Experiment timestamp (string)}

\item{parameters}{Optional: A vector of parameter values for the model}
}
\value{
An updated database object db
}
\description{
Insert results
}
\examples{
  db <- initializeDb("", "My Dataset")
  logl <- c(-4.0, -2.0, 0.0)
  names(logl) <- c("A", "B", "C")
  baselogl <- c(1.0, -1.0, 4.0)
  names(baselogl) <- names(logl)
  db <- insertResults(db, "testexperiment", "testregulator", "",
                     logl, baselineloglikelihoods=baselogl)
  closeDb(db)
}

