% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbinomGC.R
\name{pbinomGC}
\alias{pbinomGC}
\title{Graphical Calculator for Binomial Curve Probabilities}
\usage{
pbinomGC(bound,region="below",size=100,prob=0.5,graph=FALSE)
}
\arguments{
\item{bound}{A numerical vector of length 1 or 2, range of shaded rectangles}

\item{region}{A character string.  Default is "below".  Possible values are "between" (when boundary consists of two numbers),
"below", "above", and "outside" (again when boundary consists of two numbers)}

\item{size}{Number of trials}

\item{prob}{Probability of success}

\item{graph}{produce graph?}
}
\value{
Numerical value of probability.
}
\description{
Shades desired areas under rectangles of probability histogram for binomial, 
returns numerical value of the area.
}
\examples{
#This gives P(X <= 6) for binom X with 10 trials, chance of success 0.70 on each trial:
pbinomGC(6,region="below",size=10,prob=0.70)

#This gives P(45 <= X <= 55), where X is binom with 100 trials,
#chance of success on each trial p = 0.50:
pbinomGC(c(45,55),region="between",size=100,prob=0.50)

#This gives P(X >= 7) = P(X > 6), for binom X with 10 trials,
#70\% chance of success on each trial
pbinomGC(6,region="above",size=10,prob=0.7)
}
\author{
Homer White \email{hwhite0@georgetowncollege.edu}
}

