% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_qualifiers.R
\name{tw_write_qualifiers_to_cache}
\alias{tw_write_qualifiers_to_cache}
\title{Write qualifiers to cache}
\usage{
tw_write_qualifiers_to_cache(
  qualifiers_df,
  language = tidywikidatar::tw_get_language(),
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{qualifiers_df}{A data frame with two columns typically generated with \code{tw_get(include_id_and_p = FALSE)}.}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{cache_connection}{Defaults to NULL. If NULL, and caching is enabled, \code{tidywikidatar} will use a local sqlite database. A custom connection to other databases can be given (see vignette \code{caching} for details).}

\item{disconnect_db}{Defaults to TRUE. If FALSE, leaves the connection to cache open.}
}
\value{
Silently returns the same data frame provided as input. Mostly used internally for its side effects.
}
\description{
Mostly to be used internally by \code{tidywikidatar}, use with caution to keep caching consistent.
}
\examples{

q_df <- tw_get_qualifiers(
  id = "Q180099",
  p = "P26",
  language = "en",
  cache = FALSE
)

tw_write_qualifiers_to_cache(
  qualifiers_df = q_df,
  language = "en"
)
}
