% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_water.R
\name{define_water_chain}
\alias{define_water_chain}
\title{Apply \code{define_water} within a dataframe and output a column of \code{water} class to be chained to other tidywater functions}
\usage{
define_water_chain(df, output_water = "defined_water")
}
\arguments{
\item{df}{a data frame containing columns with all the parameters listed in \code{\link{define_water}}}

\item{output_water}{name of the output column storing updated parameters with the class, water. Default is "defined_water".}
}
\value{
A data frame containing a water class column.
}
\description{
This function allows \code{\link{define_water}} to be added to a piped data frame.
Its output is a \code{water} class, and can therefore be chained with "downstream" tidywater functions.
}
\details{
For large datasets, using \code{fn_once} or \code{fn_chain} may take many minutes to run. These types of functions use the furrr package
for the option to use parallel processing and speed things up. To initialize parallel processing, use
\code{plan(multisession)} or \code{plan(multicore)} (depending on your operating system) prior to your piped code with the
\code{fn_once} or \code{fn_chain} functions. Note, parallel processing is best used when your code block takes more than a minute to run,
shorter run times will not benefit from parallel processing.
}
\examples{
\donttest{
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain()

example_df <- water_df \%>\%
  define_water_chain(output_water = "This is a column of water") \%>\%
  balance_ions_chain(input_water = "This is a column of water")

# Initialize parallel processing
library(furrr)
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain()

#' #Optional: explicitly close multisession processing
plan(sequential)
}

}
\seealso{
\code{\link{define_water}}
}
