% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{calculate_hardness}
\alias{calculate_hardness}
\title{Calculate hardness from calcium and magnesium}
\usage{
calculate_hardness(ca, mg, type = "total", startunit = "mg/L")
}
\arguments{
\item{ca}{Calcium concentration in mg/L as Ca}

\item{mg}{Magnesium concentration in mg/L as Mg}

\item{type}{"total" returns total hardness, "ca" returns calcium hardness. Defaults to "total"}

\item{startunit}{Units of Ca and Mg. Defaults to mg/L}
}
\value{
A numeric value for the total hardness in mg/L as CaCO3.
}
\description{
This function takes Ca and Mg in mg/L and returns hardness in mg/L as CaCO3
}
\examples{
calculate_hardness(50, 10)

water_defined <- define_water(7, 20, 50, 100, 80, 10, 10, 10, 10, tot_po4 = 1)
calculate_hardness(water_defined@ca, water_defined@mg, "total", "M")

}
