% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{summarize_wq}
\alias{summarize_wq}
\alias{summarise_wq}
\title{Create summary table from water class}
\usage{
summarize_wq(water, params = c("general"))

summarise_wq(water, params = c("general"))
}
\arguments{
\item{water}{Source water vector created by \code{\link{define_water}}.}

\item{params}{List of water quality parameters to be summarized. Options include "general", "ions", "corrosion", and "dbps". Defaults to "general" only.}
}
\value{
A knitr_kable table of specified water quality parameters.
}
\description{
This function takes a water data frame defined by \code{\link{define_water}} and outputs a formatted summary table of
specified water quality parameters.

\code{summarise_wq()} and \code{summarize_wq()} are synonyms.
}
\details{
Use \code{\link{calculate_corrosion}} for corrosivity indicators and \code{\link{chemdose_dbp}} for modeled DBP concentrations.
}
\examples{
# Summarize general parameters
water_defined <- define_water(7, 20, 50, 100, 80, 10, 10, 10, 10, tot_po4 = 1)
summarize_wq(water_defined)

# Summarize major cations and anions
summarize_wq(water_defined, params = list("ions"))

}
