% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_load_gh.R
\name{tt_load_gh}
\alias{tt_load_gh}
\title{Load TidyTuesday data from Github}
\usage{
tt_load_gh(x, week = NULL, auth = gh::gh_token())
}
\arguments{
\item{x}{The date of data to pull (in "YYYY-MM-dd" format), or the four-digit
year as a number.}

\item{week}{Which week number to use within a given year. Only used when \code{x}
is a valid year.}

\item{auth}{A GitHub token. See \code{\link[gh:gh_token]{gh::gh_token()}} for more details.}
}
\value{
A \code{tt} object. This contains the files available for the week,
readme html, and the date of the TidyTuesday.
}
\description{
Pulls the readme and URLs of the data from the TidyTuesday
github folder based on the date provided
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# check to make sure there are requests still available
if (rate_limit_check(quiet = TRUE) > 30) {
  tt_gh <- tt_load_gh("2019-01-15")
  ## readme attempts to open the readme for the weekly dataset
  readme(tt_gh)

  agencies <- tt_download(
    tt_gh,
    files = "agencies.csv"
  )
}
\dontshow{\}) # examplesIf}
}
