% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{format_numbers_at}
\alias{format_numbers_at}
\title{Format numeric columns for display}
\usage{
format_numbers_at(.tbl, .vars, decimal_places = 1, remove_trailing_zeroes = T)
}
\arguments{
\item{.tbl}{A data frame}

\item{.vars}{A vars() list of symbolic columns}

\item{decimal_places}{Decimal places to display}

\item{remove_trailing_zeroes}{If the required decimal places are less than decimal places,
should resulting trailing zeros be removed?}
}
\value{
Value of mutate_at
}
\description{
Combines \code{\link[dplyr]{mutate_at}()} and \code{\link{as_formatted_number}()}
}
\examples{
library(tibble)
library(magrittr)
library(dplyr)
tibble(a=c(0.1, 0.238546)) \%>\%
    format_numbers_at(vars(a))
}
\seealso{
\code{\link{format_p_values_at}}
}
