% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate-Spat.R
\name{relocate.Spat}
\alias{relocate.Spat}
\alias{relocate.SpatRaster}
\alias{relocate.SpatVector}
\title{Change layer/attribute order}
\usage{
\method{relocate}{SpatRaster}(.data, ..., .before = NULL, .after = NULL)

\method{relocate}{SpatVector}(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{\code{\link[dplyr:relocate]{tidy-select}} layers/attributes to move.}

\item{.before, .after}{\code{\link[dplyr:relocate]{tidy-select}} Destination of
layers/attributes selected by \code{...}. Supplying neither will move
layers/attributes to the left-hand side; specifying both is an error.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
Use \code{relocate()} to change layer/attribute positions, using the same syntax
as \code{\link[=select]{select()}} to make it easy to move blocks of layers/attributes at once.
}
\section{terra equivalent}{


\code{terra::subset(data, c("name_layer", "name_other_layer"))}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:relocate]{dplyr::relocate()}} function.
\subsection{SpatRaster}{

Relocate layers of a SpatRaster.
}

\subsection{SpatVector}{

The result is a SpatVector with the attributes on a different order.
}
}

\examples{

library(terra)


f <- system.file("extdata/cyl_tile.tif", package = "tidyterra")
spatrast <- rast(f) \%>\% mutate(aa = 1, bb = 2, cc = 3)

names(spatrast)


spatrast \%>\%
  relocate(bb, .before = cyl_tile_3) \%>\%
  relocate(cyl_tile_1, .after = last_col())

}
\seealso{
\code{\link[dplyr:relocate]{dplyr::relocate()}}

Other dplyr verbs that operate on columns:
\code{\link{glimpse.Spat}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}}

Other dplyr methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.cols}
\concept{dplyr.methods}
