% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_regular_grid.R
\name{is_regular_grid}
\alias{is_regular_grid}
\title{Check if x and y positions conforms a regular grid}
\usage{
is_regular_grid(xy, digits = 6)
}
\arguments{
\item{xy}{A matrix, data frame or tibble of at least two columns representing
x and y coordinates.}

\item{digits}{integer to set the precision for detecting whether points are
on a regular grid (a low number of digits is a low precision).}
}
\value{
\code{invisible()} if is regular or an error message otherwise
}
\description{
Assess if the coordinates x,y of an object conforms a regular grid. This
function is called by its side effects.

This function is internally called by \code{\link[=as_spatraster]{as_spatraster()}}.
}
\examples{

p <- matrix(1:90, nrow = 45, ncol = 2)

is_regular_grid(p)


# Jitter location
set.seed(1234)
jitter <- runif(length(p)) / 10e4
p_jitter <- p + jitter

# Need to adjust digits
is_regular_grid(p_jitter, digits = 4)

}
\seealso{
\code{\link[=as_spatraster]{as_spatraster()}}

Other helpers: 
\code{\link{compare_spatrasters}()},
\code{\link{pull_crs}()}
}
\concept{helpers}
