% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{separate}
\alias{separate}
\title{Separate a character column into multiple columns}
\usage{
separate(
  .df,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  ...
)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{col}{The column to split into multiple columns}

\item{into}{New column names to split into. A character vector.
Use \code{NA} to omit the variable in the output.}

\item{sep}{Separator to split on. Can be specified or detected automatically}

\item{remove}{If TRUE, remove the input column from the output data.table}

\item{convert}{TRUE calls \code{type.convert()} with \code{as.is = TRUE} on new columns}

\item{...}{Arguments passed on to methods}
}
\description{
Separates a single column into multiple columns using a user supplied separator or regex.

If a separator is not supplied one will be automatically detected.

Note: Using automatic detection or regex will be slower than simple separators such as "," or ".".
}
\examples{
df <- data.table(x = c("a", "a.b", "a.b", NA))

# "sep" can be automatically detected (slower)
df \%>\%
  separate(x, into = c("c1", "c2"))

# Faster if "sep" is provided
df \%>\%
  separate(x, into = c("c1", "c2"), sep = ".")
}
