% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between.R
\name{between.}
\alias{between.}
\title{Do the values from x fall between the left and right bounds?}
\usage{
between.(x, left, right)
}
\arguments{
\item{x}{A numeric vector of values}

\item{left, right}{Boundary values}
}
\description{
\code{between.()} utilizes \code{data.table::between()} in the background
}
\examples{
between.(1:10, 5, 7)

test_df <- data.table(
  x = sample(1:5, 10, replace = TRUE),
  y = sample(1:5, 10, replace = TRUE)
)

# Typically used in a filter.()
test_df \%>\%
  filter.(between.(x, 1,3))

# Can also use the \%between\% operator
test_df \%>\%
  filter.(x \%between\% c(1, 3))
}
