% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_weights}
\alias{plot_weights}
\title{plot_weights}
\usage{
plot_weights(data)
}
\arguments{
\item{data}{nested data of type \code{tbl_df}.}
}
\value{
a \code{ggplot} object that plots the unit and variable weights.
}
\description{
Plot the unit and predictor variable weights generated using \code{generate_weights()}
}
\details{
See \code{grab_unit_weights()} and \code{grab_predictor_weights()}
}
\examples{

\donttest{

# Smoking example data
data(smoking)

smoking_out <-
smoking \%>\%

# initial the synthetic control object
synthetic_control(outcome = cigsale,
                  unit = state,
                  time = year,
                  i_unit = "California",
                  i_time = 1988,
                  generate_placebos=TRUE) \%>\%

# Generate the aggregate predictors used to generate the weights
  generate_predictor(time_window=1980:1988,
                     lnincome = mean(lnincome, na.rm = TRUE),
                     retprice = mean(retprice, na.rm = TRUE),
                     age15to24 = mean(age15to24, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1984:1988,
                     beer = mean(beer, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1975,
                     cigsale_1975 = cigsale) \%>\%

  generate_predictor(time_window=1980,
                     cigsale_1980 = cigsale) \%>\%

  generate_predictor(time_window=1988,
                     cigsale_1988 = cigsale) \%>\%


  # Generate the fitted weights for the synthetic control
  generate_weights(optimization_window =1970:1988,
                   Margin.ipop=.02,Sigf.ipop=7,Bound.ipop=6) \%>\%

  # Generate the synthetic control
  generate_control()

# Plot the observed and synthetic trend
smoking_out \%>\% plot_weights()

}

}
