% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab-methods.R
\name{grab_unit_weights}
\alias{grab_unit_weights}
\title{grab_unit_weights}
\usage{
grab_unit_weights(data, placebo = FALSE)
}
\arguments{
\item{data}{nested data of type \code{tbl_df}}

\item{placebo}{boolean flag; if TRUE placebo values are returned as well (if
available). Default is FALSE.}
}
\value{
tibble data frame
}
\description{
Extract the unit weights generated by \code{generate_weights()} from the synth pipeline.
}
\examples{

\donttest{

# Smoking example data
data(smoking)

smoking_out <-
smoking \%>\%

# initial the synthetic control object
synthetic_control(outcome = cigsale,
                  unit = state,
                  time = year,
                  i_unit = "California",
                  i_time = 1988,
                  generate_placebos=TRUE) \%>\%

# Generate the aggregate predictors used to generate the weights
  generate_predictor(time_window=1980:1988,
                     lnincome = mean(lnincome, na.rm = TRUE),
                     retprice = mean(retprice, na.rm = TRUE),
                     age15to24 = mean(age15to24, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1984:1988,
                     beer = mean(beer, na.rm = TRUE)) \%>\%

  generate_predictor(time_window=1975,
                     cigsale_1975 = cigsale) \%>\%

  generate_predictor(time_window=1980,
                     cigsale_1980 = cigsale) \%>\%

  generate_predictor(time_window=1988,
                     cigsale_1988 = cigsale) \%>\%


  # Generate the fitted weights for the synthetic control
  generate_weights(optimization_window =1970:1988,
                   Margin.ipop=.02,Sigf.ipop=7,Bound.ipop=6)

# Grab the unit weights for the treated unit.
smoking_out \%>\% grab_unit_weights()

# Grab the unit weights for the placebo units as well.
smoking_out \%>\% grab_unit_weights(placebo=TRUE)

}

}
