% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_count_data.r
\name{tidy_count_data}
\alias{tidy_count_data}
\title{Convert count data to a tidy data frame}
\usage{
tidy_count_data(count_data)
}
\arguments{
\item{count_data}{a data frame created with tidystats' \code{count_data}.}
}
\description{
\code{tidy_count_data} returns a tidy data frame of count statistics created with \strong{tidystats}' \code{count_data}.
}
\examples{
library(dplyr)

# Calculate counts
condition_n <- count_data(cox, condition)

# Create a tidy data frame of the count data
tidy_count_data(condition_n)

# With a grouping variable:
cox \%>\%
  group_by(sex) \%>\%
  count_data(condition) \%>\%
  tidy_count_data()

}
