% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_wilcoxon.R
\name{report_wilcoxon}
\alias{report_wilcoxon}
\title{Report function for Wilcoxon Rank Sum and Signed Rank Tests}
\usage{
report_wilcoxon(identifier, results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{results}{A tidystats list.}
}
\description{
Function to report Wilcoxon Rank Sum and Signed Rank Tests in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the default tidystats list in options()
options(tidystats_list = results)

# Report results
report(identifier = "wilcoxon_rank_sum")
report(identifier = "wilcoxon_signed_rank")

}
