% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.r
\name{describe}
\alias{describe}
\title{Calculate common descriptive statistics}
\usage{
describe(data, variable, na.rm = TRUE)
}
\arguments{
\item{data}{A data frame}

\item{variable}{The variable you want to calculate the descriptives of}

\item{na.rm}{Boolean to indicate whether missing data should be removed. The default is TRUE.}
}
\description{
\code{describe} returns a set of common descriptive statistics for a numeric variable (e.g., n, mean, sd) or for a non-numeric variable (e.g., n, pct).
}
\details{
The data set can be grouped so that descriptives will be calculated for each group level. Unlike dplyr's \code{summarize}, \code{describe} does not automatically peel off a grouping variable. The function keeps the supplied grouping. However, when descriptives are requested of a non-numeric variable, the function will return a data frame that is grouped by that variable. If the data frame was already grouped, the non-numeric variable will be added to the existing grouping variables.
}
\examples{
library(magrittr)
library(dplyr)

# Descriptives of a single variable
describe(sleep, variable = extra)
describe(sleep, variable = group)

# Descriptives of a single variable per group
sleep \%>\%
  group_by(group) \%>\%
  describe(variable = extra)

}
