% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{extract}
\alias{extract}
\title{Extract a character column into multiple columns using regular
expression groups}
\usage{
extract(
  data,
  col,
  into,
  regex = "([[:alnum:]]+)",
  remove = TRUE,
  convert = FALSE,
  ...
)
}
\arguments{
\item{data}{A tidyseurat object}

\item{col}{Column name or position. This is passed to
  [tidyselect::vars_pull()].

  This argument is passed by expression and supports
  [quasiquotation][rlang::quasiquotation] (you can unquote column
  names or column positions).}

\item{into}{Names of new variables to create as character vector.
Use `NA` to omit the variable in the output.}

\item{regex}{a regular expression used to extract the desired values.
There should be one group (defined by `()`) for each element of `into`.}

\item{remove}{If `TRUE`, remove input column from output data frame.}

\item{convert}{If `TRUE`, will run [type.convert()] with
  `as.is = TRUE` on new columns. This is useful if the component
  columns are integer, numeric or logical.

  NB: this will cause string `"NA"`s to be converted to `NA`s.}

\item{...}{Additional arguments passed on to methods.}
}
\value{
A tidyseurat objector a tibble depending on input
}
\description{
Given a regular expression with capturing groups, `extract()` turns
each group into a new column. If the groups don't match, or the input
is NA, the output will be NA.
}
\examples{

pbmc_small \%>\% tidy \%>\% extract(groups, into = "g", regex = "g([0-9])", convert = TRUE)

}
\seealso{
[separate()] to split up by a separator.
}
