% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-helpers.R
\name{select_helpers}
\alias{select_helpers}
\alias{starts_with}
\alias{ends_with}
\alias{contains}
\alias{matches}
\alias{num_range}
\alias{one_of}
\alias{everything}
\alias{last_col}
\title{Select helpers}
\usage{
starts_with(match, ignore.case = TRUE, vars = peek_vars())

ends_with(match, ignore.case = TRUE, vars = peek_vars())

contains(match, ignore.case = TRUE, vars = peek_vars())

matches(match, ignore.case = TRUE, vars = peek_vars())

num_range(prefix, range, width = NULL, vars = peek_vars())

one_of(..., .vars = peek_vars())

everything(vars = peek_vars())

last_col(offset = 0L, vars = peek_vars())
}
\arguments{
\item{match}{A string.}

\item{ignore.case}{If \code{TRUE}, the default, ignores case when matching
names.}

\item{vars, .vars}{A character vector of variable names. When called
from inside \code{\link[=select]{select()}} these are automatically set to the names
of the table.}

\item{prefix}{A prefix that starts the numeric range.}

\item{range}{A sequence of integers, like \code{1:5}}

\item{width}{Optionally, the "width" of the numeric range. For example,
a range of 2 gives "01", a range of three "001", etc.}

\item{...}{One or more character vectors.}

\item{offset}{Set it to \code{n} to select the nth var from the end.}
}
\value{
An integer vector giving the position of the matched variables.
}
\description{
These functions allow you to select variables based on their names.
\itemize{
\item \code{starts_with()}: starts with a prefix
\item \code{ends_with()}: ends with a prefix
\item \code{contains()}: contains a literal string
\item \code{matches()}: matches a regular expression
\item \code{num_range()}: a numerical range like x01, x02, x03.
\item \code{one_of()}: variables in character vector.
\item \code{everything()}: all variables.
\item \code{last_col()}: last variable, possibly with an offset.
}
}
\examples{
nms <- names(iris)
vars_select(nms, starts_with("Petal"))
vars_select(nms, ends_with("Width"))
vars_select(nms, contains("etal"))
vars_select(nms, matches(".t."))
vars_select(nms, Petal.Length, Petal.Width)
vars_select(nms, everything())
vars_select(nms, last_col())
vars_select(nms, last_col(offset = 2))

vars <- c("Petal.Length", "Petal.Width")
vars_select(nms, one_of(vars))
}
