% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel-date-functions.R
\name{excel_date_functions}
\alias{excel_date_functions}
\alias{AS_DATE}
\alias{AS_DATETIME}
\alias{DATE}
\alias{DATEVALUE}
\alias{YMD}
\alias{MDY}
\alias{DMY}
\alias{YMD_HMS}
\alias{MDY_HMS}
\alias{DMY_HMS}
\alias{YMD_HM}
\alias{MDY_HM}
\alias{DMY_HM}
\alias{YMD_H}
\alias{MDY_H}
\alias{DMY_H}
\alias{WEEKDAY}
\alias{WDAY}
\alias{DOW}
\alias{MONTHDAY}
\alias{MDAY}
\alias{DOM}
\alias{QUARTERDAY}
\alias{QDAY}
\alias{DAY}
\alias{WEEKNUM}
\alias{WEEK}
\alias{WEEKNUM_ISO}
\alias{MONTH}
\alias{QUARTER}
\alias{YEAR}
\alias{YEAR_ISO}
\alias{DATE_TO_NUMERIC}
\alias{DATE_TO_DECIMAL}
\alias{SECOND}
\alias{MINUTE}
\alias{HOUR}
\alias{NOW}
\alias{TODAY}
\alias{EOMONTH}
\alias{EDATE}
\alias{NET_WORKDAYS}
\alias{COUNT_DAYS}
\alias{YEARFRAC}
\alias{DATE_SEQUENCE}
\alias{WORKDAY_SEQUENCE}
\alias{HOLIDAY_SEQUENCE}
\alias{HOLIDAY_TABLE}
\alias{FLOOR_DATE}
\alias{FLOOR_DAY}
\alias{FLOOR_WEEK}
\alias{FLOOR_MONTH}
\alias{FLOOR_QUARTER}
\alias{FLOOR_YEAR}
\alias{CEILING_DATE}
\alias{CEILING_DAY}
\alias{CEILING_WEEK}
\alias{CEILING_MONTH}
\alias{CEILING_QUARTER}
\alias{CEILING_YEAR}
\alias{ROUND_DATE}
\alias{ROUND_DAY}
\alias{ROUND_WEEK}
\alias{ROUND_MONTH}
\alias{ROUND_QUARTER}
\alias{ROUND_YEAR}
\title{Excel Date and Time Functions}
\usage{
AS_DATE(x, ...)

AS_DATETIME(x, ...)

DATE(year, month, day)

DATEVALUE(x, ...)

YMD(x, ...)

MDY(x, ...)

DMY(x, ...)

YMD_HMS(x, ...)

MDY_HMS(x, ...)

DMY_HMS(x, ...)

YMD_HM(x, ...)

MDY_HM(x, ...)

DMY_HM(x, ...)

YMD_H(x, ...)

MDY_H(x, ...)

DMY_H(x, ...)

WEEKDAY(x, ..., label = FALSE, abbr = TRUE)

WDAY(x, ..., label = FALSE, abbr = TRUE)

DOW(x, ..., label = FALSE, abbr = TRUE)

MONTHDAY(x, ...)

MDAY(x, ...)

DOM(x, ...)

QUARTERDAY(x, ...)

QDAY(x, ...)

DAY(x, ...)

WEEKNUM(x, ...)

WEEK(x, ...)

WEEKNUM_ISO(x, ...)

MONTH(x, ..., label = FALSE, abbr = TRUE)

QUARTER(x, ..., include_year = FALSE, fiscal_start = 1)

YEAR(x, ...)

YEAR_ISO(x, ...)

DATE_TO_NUMERIC(x, ...)

DATE_TO_DECIMAL(x, ...)

SECOND(x, ...)

MINUTE(x, ...)

HOUR(x, ...)

NOW(...)

TODAY(...)

EOMONTH(start_date, months = 0)

EDATE(start_date, months = 0)

NET_WORKDAYS(start_date, end_date, remove_weekends = TRUE, holidays = NULL)

COUNT_DAYS(start_date, end_date)

YEARFRAC(start_date, end_date)

DATE_SEQUENCE(start_date, end_date, by = "day")

WORKDAY_SEQUENCE(start_date, end_date, remove_weekends = TRUE, holidays = NULL)

HOLIDAY_SEQUENCE(
  start_date,
  end_date,
  calendar = c("NYSE", "LONDON", "NERC", "TSX", "ZURICH")
)

HOLIDAY_TABLE(years, pattern = ".")

FLOOR_DATE(x, ..., by = "day")

FLOOR_DAY(x, ...)

FLOOR_WEEK(x, ...)

FLOOR_MONTH(x, ...)

FLOOR_QUARTER(x, ...)

FLOOR_YEAR(x, ...)

CEILING_DATE(x, ..., by = "day")

CEILING_DAY(x, ...)

CEILING_WEEK(x, ...)

CEILING_MONTH(x, ...)

CEILING_QUARTER(x, ...)

CEILING_YEAR(x, ...)

ROUND_DATE(x, ..., by = "day")

ROUND_DAY(x, ...)

ROUND_WEEK(x, ...)

ROUND_MONTH(x, ...)

ROUND_QUARTER(x, ...)

ROUND_YEAR(x, ...)
}
\arguments{
\item{x}{A vector of date or date-time objects}

\item{...}{Parameters passed to underlying \code{lubridate} functions.}

\item{year}{Used in \code{\link[=DATE]{DATE()}}}

\item{month}{Used in \code{\link[=DATE]{DATE()}}}

\item{day}{Used in \code{\link[=DATE]{DATE()}}}

\item{label}{A logical used for \code{\link[=MONTH]{MONTH()}} and \code{\link[=WEEKDAY]{WEEKDAY()}} Date Extractors to decide whether or not to return names
(as ordered factors) or numeric values.}

\item{abbr}{A logical used for \code{\link[=MONTH]{MONTH()}} and \code{\link[=WEEKDAY]{WEEKDAY()}}. If \code{label = TRUE}, used to determine if
full names (e.g. Wednesday) or abbreviated names (e.g. Wed) should be returned.}

\item{include_year}{A logical value used in \code{\link[=QUARTER]{QUARTER()}}. Determines whether or not to return 2020 Q3 as \code{3} or \code{2020.3}.}

\item{fiscal_start}{A numeric value used in \code{\link[=QUARTER]{QUARTER()}}. Determines the fiscal-year starting quarter.}

\item{start_date}{Used in Date Math and Date Sequence operations. The starting date in the calculation.}

\item{months}{Used to offset months in \code{\link[=EOMONTH]{EOMONTH()}} AND \code{\link[=EDATE]{EDATE()}} Date Math calculations}

\item{end_date}{Used in Date Math and Date Sequence operations. The ending date in the calculation.}

\item{remove_weekends}{A logical value used in Date Sequence and Date Math calculations.
Indicates whether or not weekends should be removed from the calculation.}

\item{holidays}{A vector of dates corresponding to holidays that should be removed from the calculation.}

\item{by}{Used to determine the gap in Date Sequence calculations and value to round to in Date Collapsing operations.
Acceptable values are: A character string, containing one of \code{"day"}, \code{"week"}, \code{"month"}, \code{"quarter"} or \code{"year"}.}

\item{calendar}{The calendar to be used in Date Sequence calculations for Holidays from the \code{timeDate} package.
Acceptable values are: \code{"NYSE"}, \code{"LONDON"}, \code{"NERC"}, \code{"TSX"}, \code{"ZURICH"}}

\item{years}{A numeric vector of years to return Holidays for in \code{\link[=HOLIDAY_TABLE]{HOLIDAY_TABLE()}}}

\item{pattern}{Used to filter Holidays (e.g. \code{pattern = "Easter"}). A "regular expression" filtering pattern.}
}
\value{
\itemize{
\item \strong{Converters} - Date or date-time object the length of x
\item \strong{Extractors} - Returns information from a time-stamp.
\item \strong{Current Time} - Returns the current date/date-time based on your locale.
\item \strong{Date Math} - Numeric values or Date Values depending on the calculation.
\item \strong{Date Sequences} - Return a vector of dates or a Holiday Table (\code{tibble}).
\item \strong{Date Collapsers} - Date or date-time object the length of x
}
}
\description{
50+ date and time functions familiar to users coming from an \strong{Excel Background.}
The main benefits are:
\enumerate{
\item Integration of the amazing \code{lubridate} package for handling dates and times
\item Integration of Holidays from \code{timeDate} and Business Calendars
\item New Date Math and Date Sequence Functions that factor in Business Calendars (e.g. \code{\link[=EOMONTH]{EOMONTH()}}, \code{\link[=NET_WORKDAYS]{NET_WORKDAYS()}})
}

These functions are designed to help users coming from an \strong{Excel background}.
Most functions replicate the behavior of Excel:
\itemize{
\item Names in most cases match Excel function names
\item Functionality replicates Excel
\item By default, missing values are ignored (same as in Excel)
}
}
\details{
\strong{Converters} - Make date and date-time from text (character data)
\itemize{
\item General String-to-Date Conversion: \code{\link[=AS_DATE]{AS_DATE()}}, \code{\link[=AS_DATETIME]{AS_DATETIME()}}
\item Format-Specific String-to-Date Conversion: \code{\link[=YMD]{YMD()}} (YYYY-MM-DD), \code{\link[=MDY]{MDY()}} (MM-DD-YYYY), \code{\link[=DMY]{DMY()}} (DD-MM-YYYY)
\item Hour-Minute-Second Conversion: \code{\link[=YMD_HMS]{YMD_HMS()}}, \code{\link[=YMD_HM]{YMD_HM()}}, and friends.
}

\strong{Extractors} - Returns information from a time-stamp.
\itemize{
\item Extractors: \code{\link[=SECOND]{SECOND()}}, \code{\link[=MINUTE]{MINUTE()}}, \code{\link[=HOUR]{HOUR()}}, \code{\link[=DAY]{DAY()}}, \code{\link[=WEEK]{WEEK()}}, \code{\link[=MONTH]{MONTH()}}, \code{\link[=QUARTER]{QUARTER()}}, \code{\link[=YEAR]{YEAR()}}
}

\strong{Current Time} - Returns the current date/date-time based on your locale.
\itemize{
\item \code{\link[=NOW]{NOW()}}, \code{\link[=TODAY]{TODAY()}}
}

\strong{Date Math} - Perform popular Excel date calculations
\itemize{
\item \code{\link[=EOMONTH]{EOMONTH()}} - End of Month
\item \code{\link[=NET_WORKDAYS]{NET_WORKDAYS()}}, \code{\link[=COUNT_DAYS]{COUNT_DAYS()}} - Return number of days between 2 dates factoring in working days and holidays
\item \code{\link[=YEARFRAC]{YEARFRAC()}} - Return the fractional period of the year that has been completed between 2 dates.
}

\strong{Date Sequences} - Return a vector of dates or a Holiday Table (\code{tibble}).
\itemize{
\item \code{\link[=DATE_SEQUENCE]{DATE_SEQUENCE()}}, \code{\link[=WORKDAY_SEQUENCE]{WORKDAY_SEQUENCE()}}, \link{HOLIDAY_SEQUENCE} - Return a sequence of dates between 2 dates that
factor in workdays and \code{timeDate} holiday calendars for popular business calendars including NYSE and London stock exchange.
}

\strong{Date Collapsers} - Collapse a date sequence (useful in \code{dplyr::group_by()} and \code{\link[=pivot_table]{pivot_table()}})
\itemize{
\item \code{\link[=FLOOR_DATE]{FLOOR_DATE()}}, \code{\link[=FLOOR_DAY]{FLOOR_DAY()}}, \code{\link[=FLOOR_WEEK]{FLOOR_WEEK()}}, \code{\link[=FLOOR_MONTH]{FLOOR_MONTH()}}, \code{\link[=FLOOR_QUARTER]{FLOOR_QUARTER()}}, \code{\link[=FLOOR_YEAR]{FLOOR_YEAR()}}
\item Similar functions exist for CEILING and ROUND. These are wrappers for \code{lubridate} functions.
}
}
\examples{
# Libraries
library(lubridate)

# --- Basic Usage ----

# Converters ---
AS_DATE("2011 Jan-01") # General
YMD("2011 Jan-01")     # Year, Month-Day Format
MDY("01-02-20")        # Month-Day, Year Format (January 2nd, 2020)
DMY("01-02-20")        # Day-Month, Year Format (February 1st, 2020)

# Extractors ---
WEEKDAY("2020-01-01")                                  # Labelled Day
WEEKDAY("2020-01-01", label = FALSE)                   # Numeric Day
WEEKDAY("2020-01-01", label = FALSE, week_start = 1)   # Start at 1 (Monday) vs 7 (Sunday)
MONTH("2020-01-01")
QUARTER("2020-01-01")
YEAR("2020-01-01")

# Current Date-Time ---
NOW()
TODAY()

# Date Math ---
EOMONTH("2020-01-01")
EOMONTH("2020-01-01", months = 1)
NET_WORKDAYS("2020-01-01", "2020-07-01") # 131 Skipping Weekends
NET_WORKDAYS("2020-01-01", "2020-07-01",
             holidays = HOLIDAY_SEQUENCE("2020-01-01", "2020-07-01",
                                         calendar = "NYSE")) # 126 Skipping 5 NYSE Holidays

# Date Sequences ---
DATE_SEQUENCE("2020-01-01", "2020-07-01")
WORKDAY_SEQUENCE("2020-01-01", "2020-07-01")
HOLIDAY_SEQUENCE("2020-01-01", "2020-07-01", calendar = "NYSE")
WORKDAY_SEQUENCE("2020-01-01", "2020-07-01",
                 holidays = HOLIDAY_SEQUENCE("2020-01-01", "2020-07-01",
                                             calendar = "NYSE"))

# Date Collapsers ---
FLOOR_DATE(AS_DATE("2020-01-15"), by = "month")
CEILING_DATE(AS_DATE("2020-01-15"), by = "month")
CEILING_DATE(AS_DATE("2020-01-15"), by = "month") - ddays(1) # EOMONTH using lubridate

# --- Usage with tidyverse ---

# Calculate returns by symbol/year/quarter
FANG \%>\%
    pivot_table(
        .rows       = c(symbol, ~ QUARTER(date)),
        .columns    = ~ YEAR(date),
        .values     = ~ PCT_CHANGE_FIRSTLAST(adjusted)
    )

}
