% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_add_sf.R
\name{gt_add_sf}
\alias{gt_add_sf}
\title{Add an simple feature geometry to a \code{gen_tibble}}
\usage{
gt_add_sf(x, coords = NULL, crs = NULL, sfc_column = NULL)
}
\arguments{
\item{x}{a \code{\link{gen_tibble}} object}

\item{coords}{a vector of length 2, giving the names of the x and y columns
in \code{x} (i.e. the coordinates, e.g. longitude and latitude). If \code{coords} is
not provided, the geometry column must be provided.}

\item{crs}{the coordinate reference system of the coordinates. If this is not
set, it will be set to the default value of \code{sf::st_crs(4326)}.}

\item{sfc_column}{the name of an \code{\link[sf:sfc]{sf::sfc}} column to be used as the
geometry}
}
\value{
a \code{\link{gen_tibble}} object with an additional geometry column (and thus
belonging also to \code{sf} class).
}
\description{
\code{gt_add_sf} adds an active sf geometry column to a \code{gen_tibble} object.  The
resulting \code{gen_tbl} inherits from \code{sf} and can be used with functions from
the \code{sf} package. It is possible to either create a \code{\link[sf:sfc]{sf::sfc}} geometry
column from coordinates, or to provide an existing geometry column (which
will then become the active geometry for \code{sf}).
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Add some coordinates
example_gt <- example_gt \%>\% mutate(
  longitude = c(0, 0, 2, 2, 0, 2, 2),
  latitude = c(51, 51, 49, 49, 51, 41, 41)
)

# Convert lat and long to sf:
example_gt <- gt_add_sf(x = example_gt, coords = c("longitude", "latitude"))

# Check class
class(example_gt)
}
