% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_distruct.R
\name{scale_fill_distruct}
\alias{scale_fill_distruct}
\title{Scale constructor using the distruct colours}
\usage{
scale_fill_distruct(guide = "none", ...)
}
\arguments{
\item{guide}{guide function passed to \code{\link[ggplot2:scale_manual]{ggplot2::scale_fill_manual()}}.
Defaults to "none", set to "legend" if a legend is required.}

\item{...}{further parameters to be passed to \code{\link[ggplot2:scale_manual]{ggplot2::scale_fill_manual()}}}
}
\value{
a scale constructor to be used with ggplot
}
\description{
A wrapper around \code{\link[ggplot2:scale_manual]{ggplot2::scale_fill_manual()}}, using the distruct colours
from \code{\link{distruct_colours}}.
}
\examples{
library(ggplot2)
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA object
pca <- gt_pca_partialSVD(lobsters)

# Colour by population
autoplot(pca, type = "scores") +
  aes(colour = lobsters$population) + scale_fill_distruct()
}
