% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-general.R
\name{common_arguments}
\alias{common_arguments}
\title{Common arguments}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{data}{The data to be displayed in this layer. There are three options:
\itemize{
\item If \code{all_rows()} (the default) the complete dataset is displayed.
\item A \code{function} to subset the plot data. See \code{filter_rows()} and friends.
\item A \code{data.frame} to override the plot data.
}}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{rasterize}{If \code{FALSE} (the default) the layer will be constructed of
vector shapes. If \code{TRUE} the layer will be rasterized to a pixel image. This can
be useful when plotting many individual objects (1,000 or more) compromises
the performance of the generated PDF file.}

\item{rasterize_dpi}{The resolution in dots per inch (dpi) used for rastering
the layer if \code{rasterize} is \code{TRUE}. The default is \code{300} dpi.}

\item{shape}{An \code{integer} between \code{0} and \code{24}, representing the shape of the
plot symbol.

\figure{unnamed-chunk-1-1.png}}

\item{size}{A \code{number} representing the size of the plot symbol. Typical
values range between \code{1} and \code{3}.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{...}{Arguments passed on to the \code{geom} function.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}

\item{color}{A hex color for the stroke color. For example, \code{"#FFFFFF"} for white.}

\item{fill}{A hex color for the fill color. For example, \code{"#FFFFFF"} for white.}

\item{saturation}{A \code{number} between \code{0} and \code{1} for the color saturation of an object. A value of \code{0} is completely desaturated (white), \code{1} is the original color.}

\item{group}{Variable in the dataset to be used for grouping.}

\item{reverse}{Whether the order should be reversed or not. Defaults to \code{FALSE}, meaning not reversed.}

\item{.reverse}{Whether the order should be reversed or not. Defaults to \code{FALSE}, meaning not reversed.}

\item{scale_cut}{Scale cut function to be applied. See \code{scales::cut_short_scale()} and friends.}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{replace_na}{Whether to replace \code{count = NA} with \code{count = 0}.}

\item{width}{Width of the plot area. Defaults to \code{50}.}

\item{height}{Height of the plot area. Defaults to \code{50}.}

\item{unit}{Unit of the plot area width and height. Defaults to \code{mm}.}

\item{force_continuous}{Whether to force the axis to be continuous. Defaults to \code{FALSE}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Common arguments
}
\keyword{internal}
