% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-misc.R
\name{add_violin}
\alias{add_violin}
\title{Add violin plot}
\usage{
add_violin(
  plot,
  dodge_width = NULL,
  alpha = 0.3,
  saturation = 1,
  draw_quantiles = NULL,
  trim = FALSE,
  linewidth = 0.25,
  scale = "width",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults to \code{0.8}.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}

\item{saturation}{A \code{number} between \code{0} and \code{1} for the color saturation of an object. A value of \code{0} is completely desaturated (white), \code{1} is the original color.}

\item{draw_quantiles}{If \code{not(NULL)} (default), draw horizontal lines
at the given quantiles of the density estimate.}

\item{trim}{If \code{TRUE} (default), trim the tails of the violins
to the range of the data. If \code{FALSE}, don't trim the tails.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{scale}{if "area" (default), all violins have the same area (before trimming
the tails). If "count", areas are scaled proportionally to the number of
observations. If "width", all violins have the same maximum width.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add violin plot
}
\examples{
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_violin()

# Changing arguments:
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_violin(saturation = 0.6)

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_violin(draw_quantiles = c(0.25, 0.5, 0.75))

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_violin(trim = TRUE)

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_violin(linewidth = 1)

}
