% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ndr.R
\name{read_ndr}
\alias{read_ndr}
\title{Import NDR Line-lists into R}
\usage{
read_ndr(path, type = "treatment", ...)
}
\arguments{
\item{path}{Path to the csv file on your computer. The file path should be specified in the
format "C:/users/Desktop/your file.csv" or something similar.}

\item{type}{type of line list to be imported. Currently, the \code{read_ndr()} supports any of \code{treatment}, \code{recency} or \code{hts} line-lists.}

\item{...}{passes other arguments supplied based on the specific NDR line-list to be read. NDR treatment line-list requires the
\code{time_stamp} argument for the day of reference of the treatment line-list, and an optional \code{quiet} argument (which
defaults to FALSE) denoting if R should also print the message about the new columns created. An optional \code{cols} can also
be used to supply specific column type to allow the user control over the variable types should the default satisfy the user need.}
}
\value{
nicely formatted line-list
}
\description{
Import the basic NDR patient-level line lists (treatment, recent infection, and HTS) into R. Column names and types are appropriately formatted using the \code{type} argument.
}
\examples{
# Read \code{ndr_example.csv} from a path
\donttest{
file_path <- system.file("extdata", "ndr_example.csv", package = "tidyndr")
read_ndr(file_path, time_stamp = "2021-02-15")
}
# Read using a link to the NDR csv file on the internet
\donttest{
file_path <- "https://raw.githubusercontent.com/stephenbalogun/example_files/main/ndr_example.csv"
read_ndr(file_path, time_stamp = "2021-02-15")
}
}
