% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_mistral.R
\name{send_mistral_batch}
\alias{send_mistral_batch}
\title{Send a Batch of Requests to the Mistral API}
\usage{
send_mistral_batch(
  .llms,
  .model = "mistral-small-latest",
  .endpoint = "/v1/chat/completions",
  .metadata = NULL,
  .temperature = 0.7,
  .top_p = 1,
  .max_tokens = 1024,
  .min_tokens = NULL,
  .seed = NULL,
  .stop = NULL,
  .dry_run = FALSE,
  .overwrite = FALSE,
  .max_tries = 3,
  .timeout = 60,
  .id_prefix = "tidyllm_mistral_req_"
)
}
\arguments{
\item{.llms}{A list of LLMMessage objects containing conversation histories.}

\item{.model}{The Mistral model version (default: "mistral-small-latest").}

\item{.endpoint}{The API endpoint (default: "/v1/chat/completions").}

\item{.metadata}{Optional metadata for the batch.}

\item{.temperature}{Sampling temperature to use, between \code{0.0} and \code{1.5}. Higher values make the output more random (default: \code{0.7}).}

\item{.top_p}{Nucleus sampling parameter, between \code{0.0} and \code{1.0} (default: \code{1}).}

\item{.max_tokens}{The maximum number of tokens to generate in the completion (default: \code{1024}).}

\item{.min_tokens}{The minimum number of tokens to generate (optional).}

\item{.seed}{Random seed for deterministic outputs (optional).}

\item{.stop}{Stop generation at specific tokens or strings (optional).}

\item{.dry_run}{Logical; if \code{TRUE}, returns the prepared request without executing it (default: \code{FALSE}).}

\item{.overwrite}{Logical; if \code{TRUE}, allows overwriting existing custom IDs (default: \code{FALSE}).}

\item{.max_tries}{Maximum retry attempts for requests (default: \code{3}).}

\item{.timeout}{Request timeout in seconds (default: \code{60}).}

\item{.id_prefix}{Prefix for generating custom IDs (default: \code{"tidyllm_mistral_req_"}).}
}
\value{
The \code{prepared_llms} list with the \code{batch_id} attribute attached.
}
\description{
Send a Batch of Requests to the Mistral API
}
