% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.tidylda.R
\name{print.tidylda}
\alias{print.tidylda}
\title{Print Method for tidylda}
\usage{
\method{print}{tidylda}(x, digits = max(3L, getOption("digits") - 3L), n = 5, ...)
}
\arguments{
\item{x}{an object of class \code{tidylda}}

\item{digits}{minimal number of significant digits}

\item{n}{Number of rows to show in each displayed \code{\link[tibble]{tibble}}.}

\item{...}{further arguments passed to or from other methods}
}
\value{
Silently returns \code{x}
}
\description{
Print a summary for objects of class \code{tidylda}
}
\examples{
\donttest{
dtm <- textmineR::nih_sample_dtm

lda <- tidylda(data = dtm, k = 10, iterations = 100)

print(lda)

lda

print(lda, digits = 2)
}
}
