% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gather_keys.r
\name{gather_keys}
\alias{gather_keys}
\title{Stack a JSON {"key": value} object}
\usage{
gather_keys(x, column.name = "key")
}
\arguments{
\item{x}{a tbl_json whose JSON attribute should always be an object}

\item{column.name}{the name to give to the column of key names created}
}
\value{
a tbl_json with a new column (column.name) that captures the keys
  and JSON attribute of the associated value data
}
\description{
Given a JSON key value structure, like {"key1": 1, "key2": 2}, the
gather_keys() function duplicates the rows of the tbl_json data.frame for
every key, adds a new column (default name "key") to capture the key names,
and then dives into the JSON values to enable further manipulation with
downstream tidyjson functions.
}
\details{
This allows you to *enter into* the keys of the objects just like `gather_array`
let you enter elements of the array.
}
\examples{
library(magrittr)  # for \%>\%
'{"name": "bob", "age": 32}' \%>\% gather_keys \%>\% json_types
}

