% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realtime-webservice.R
\name{realtime_ws}
\alias{realtime_ws}
\title{Download realtime data from the ECCC web service}
\format{
A tibble with 6 variables:
\describe{
\item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
\item{Date}{Observation date and time. Formatted as a POSIXct class as UTC for consistency.}
\item{Name_En}{Code name in English}
\item{Value}{Value of the measurement.}
\item{Unit}{Value units}
\item{Grade}{future use}
\item{Symbol}{future use}
\item{Approval}{future use}
\item{Parameter}{Numeric parameter code}
\item{Code}{Letter parameter code}
}
}
\usage{
realtime_ws(
  station_number,
  parameters = NULL,
  start_date = Sys.Date() - 30,
  end_date = Sys.Date()
)
}
\arguments{
\item{station_number}{Water Survey of Canada station number.}

\item{parameters}{parameter ID. Can take multiple entries. Parameter is a numeric code. See \code{param_id}
for some options though undocumented parameters may be implemented. Defaults to Water level provisional, Secondary water level,
Tertiary water level, Discharge Provisional, Discharge, sensor, Water temperature, Secondary water temperature, Accumulated precipitation}

\item{start_date}{Accepts either YYYY-MM-DD or YYYY-MM-DD HH:MM:SS.
If only start date is supplied (i.e. YYYY-MM-DD) values are returned from the start of that day.
Defaults to 30 days before current date. Time is supplied in UTC.}

\item{end_date}{Accepts either YYYY-MM-DD or YYYY-MM-DD HH:MM:SS.
If only a date is supplied (i.e. YYYY-MM-DD) values are returned from the end of that day.
Defaults to current date. Time is supplied in UTC.}
}
\description{
Function to actually retrieve data from ECCC web service.
The maximum number of days that can be queried depends on other parameters being requested.
If one station is requested, 18 months of data can be requested. If you continually receiving
errors when invoking this function, reduce the number of observations (via station_number,
parameters or dates) being requested.
}
\examples{
\dontrun{

ws_08 <- realtime_ws(
  station_number = c("08NL071", "08NM174"),
  parameters = c(47, 5)
)

fivedays <- realtime_ws(
  station_number = c("08NL071", "08NM174"),
  parameters = c(47, 5),
  end_date = Sys.Date(), # today
  start_date = Sys.Date() - 5 # five days ago
)
}
}
\seealso{
Other realtime functions: 
\code{\link{realtime_dd}()},
\code{\link{realtime_stations}()}
}
\concept{realtime functions}
