% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_stations.R
\name{hy_stations}
\alias{hy_stations}
\title{Extract station information from the HYDAT database}
\format{A tibble with 15 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{STATION_NAME}{Official name for station identification}
  \item{PROV_TERR_STATE_LOC}{The province, territory or state in which the station is located}
  \item{REGIONAL_OFFICE_ID}{The identifier of the regional office responsible for the station. 
  Links to \link[tidyhydat]{hy_reg_office_list}}
  \item{LATITUDE}{North-South Coordinates of the gauging station in decimal degrees}
  \item{LONGITUDE}{East-West Coordinates of the gauging station in decimal degrees}
  \item{DRAINAGE_AREA_GROSS}{The total surface area that drains to the gauge site (km^2)}
  \item{DRAINAGE_AREA_EFFECT}{The portion of the drainage basin that contributes runoff to 
  the gauge site, calculated by subtracting any noncontributing portion from the 
  gross drainage area (km^2)}
  \item{RHBN}{Logical. Reference Hydrometric Basin Network station. The Reference Hydrometric 
  Basin Network (RHBN) is a sub-set of the national network that has been identified 
  for use in the detection, monitoring, and assessment of climate change.}
  \item{REAL_TIME}{Logical. Indicates if a station has the capacity to deliver data in 
  real-time or near real-time}
  \item{CONTRIBUTOR_ID}{Unique ID of an agency that contributes data to the 
  HYDAT database. The agency is non-WSC and non WSC funded}
  \item{OPERATOR_ID}{Unique ID of an agency that operates a hydrometric station}
  \item{DATUM_ID}{Unique ID for a datum}
}}
\source{
HYDAT
}
\usage{
hy_stations(station_number = NULL, hydat_path = NULL,
  prov_terr_state_loc = NULL)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The default for this argument is to look for hydat in the same location where it
was saved by using \code{download_hydat}. Therefore this argument is almost always omitted from a function call. 
You can see where hydat was downloaded using \code{hy_dir()}}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}}
}
\value{
A tibble of stations and associated metadata
}
\description{
Provides wrapper to turn the hy_stations table in HYDAT into a tidy data frame of station information. \code{station_number} and
\code{prov_terr_state_loc} can both be supplied. If both are omitted all values from the \code{hy_stations} table are returned. This
is the entry point for most analyses is tidyhydat as establish the stations for consideration is likely the first step in many
instances.
}
\examples{
\dontrun{
## Multiple stations province not specified
hy_stations(station_number = c("08NM083","08NE102"))

## Multiple province, station number not specified
hy_stations(prov_terr_state_loc = c("AB","YT"))
}


}
\seealso{
Other HYDAT functions: \code{\link{hy_agency_list}},
  \code{\link{hy_annual_instant_peaks}},
  \code{\link{hy_annual_stats}},
  \code{\link{hy_daily_flows}},
  \code{\link{hy_daily_levels}}, \code{\link{hy_daily}},
  \code{\link{hy_data_symbols}},
  \code{\link{hy_data_types}}, \code{\link{hy_datum_list}},
  \code{\link{hy_monthly_flows}},
  \code{\link{hy_monthly_levels}},
  \code{\link{hy_reg_office_list}},
  \code{\link{hy_sed_daily_loads}},
  \code{\link{hy_sed_daily_suscon}},
  \code{\link{hy_sed_monthly_loads}},
  \code{\link{hy_sed_monthly_suscon}},
  \code{\link{hy_sed_samples_psd}},
  \code{\link{hy_sed_samples}},
  \code{\link{hy_stn_data_coll}},
  \code{\link{hy_stn_data_range}},
  \code{\link{hy_stn_op_schedule}},
  \code{\link{hy_stn_regulation}}, \code{\link{hy_version}}
}
