% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{morph}
\alias{morph}
\alias{unmorph}
\alias{crystallise}
\alias{crystallize}
\title{Create a temporary alternative representation of the graph to compute on}
\usage{
morph(.data, .f, ...)

unmorph(.data)

crystallise(.data)

crystallize(.data)
}
\arguments{
\item{.data}{A \code{tbl_graph} or a \code{morphed_tbl_graph}}

\item{.f}{A morphing function. See \link{morphers} for a list of provided one.}

\item{...}{Arguments passed on to the morpher}
}
\value{
A \code{morphed_tbl_graph}
}
\description{
The \code{morph}/\code{unmorph} verbs are used to create temporary representations of
the graph, such as e.g. its search tree or a subgraph. A morphed graph will
accept any of the standard \code{dplyr} verbs, and changed to the data is
automatically propagated to the original graph when unmorphing. Tidygraph
comes with a range of \link{morphers}, but is it also possible to supply your own.
See Details for the requirement for custom morphers. The \code{crystallise} verb
is used to extract the temporary graph representation into a tibble
containing one separate graph per row and a \code{name} and \code{graph} column holding
the name of each graph and the graph itself respectively.
}
\details{
It is only possible to change and add to node and edge data from a
morphed state. Any filtering/removal of nodes and edges will not result in
removal from the main graph. However, nodes and edges not present in the
morphed state will be unaffected in the main graph when unmorphing (if new
columns were added during the morhped state they will be filled with \code{NA}).

Morphing an already morhped graph will unmorph prior to applying the new
morph.

During a morphed state, the mapping back to the original graph is stored in
\code{.tidygraph_node_index} and \code{.tidygraph_edge_index} columns. These are
accesible but protected, meaning that any changes to them with e.g. mutate
will be ignored. Furthermore, if the morph results in the merging of nodes
and/or edges the original data is stored in a \code{.data} column. This is
protected as well.

When supplying your own morphers the morphing function should accept a
\code{tbl_graph} as its first input. The provided graph will already have nodes
and edges mapped with a \code{.tidygraph_node_index} and \code{.tidygraph_edge_index}
column. The return value must be a \code{tbl_graph} or a list of \code{tbl_graph}s and
these must contain either a \code{.tidygraph_node_index} column or a
\code{.tidygraph_edge_index} column (or both). Note that it is possible for the
morph to have the edges mapped back to the original nodes and vice versa
(e.g. as with \link{to_linegraph}). In that case the edge data in the morphed
graph(s) will contain a \code{.tidygraph_node_index} column and or the node data a
\code{.tidygraph_edge_index} column. If the morphing results in the collapse of
multiple columns or edges the index columns should be converted to list
columns mapping the new node/edge back to all the nodes/edges it represents.
Furthermore the original node/edge data should be collapsed to a list of
tibbles, with the row order matching the order in the index column element.
}
\examples{
create_notable('meredith') \%>\%
  mutate(group = group_infomap()) \%>\%
  morph(to_contracted, group) \%>\%
  mutate(group_centrality = centrality_pagerank()) \%>\%
  unmorph()
}
