% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{gate_interactive}
\alias{gate_interactive}
\title{Interactively gate data with a simple scatter plot}
\usage{
gate_interactive(x, y, colour = NULL, shape = NULL, alpha = 1, size = 2)
}
\arguments{
\item{x}{A vector representing the X dimension.}

\item{y}{A vector representing the Y dimension.}

\item{colour}{A single colour code string compatible with ggplot2. Or, a vector representing the 
point colour.}

\item{shape}{A single ggplot2 shape numeric ranging from 0 to 127. Or, a vector representing the 
point shape, coercible to a factor of 6 or less levels.}

\item{alpha}{A single ggplot2 alpha numeric ranging from 0 to 1. Or, a vector representing the 
point alpha, either a numeric or factor of 6 or less levels.}

\item{size}{A single ggplot2 size numeric ranging from 0 to 20. Or, a vector representing the 
point size, either a numeric or factor of 6 or less levels.}
}
\value{
A vector of strings, of the gates each X and Y coordinate pair is within. If gates are
drawn interactively, they are temporarily saved to `tidygate_env$gates`
}
\description{
Create an interactive scatter plot based on user-defined X and Y coordinates. Colour, shape, size 
and alpha can be defined as constant values, or can be controlled by values in a specified 
column.
}
