% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_dt.R
\name{mutate_dt}
\alias{mutate_dt}
\alias{transmute_dt}
\title{Mutate columns in data.frame}
\usage{
mutate_dt(.data, ..., by)

transmute_dt(.data, ..., by)
}
\arguments{
\item{.data}{data.frame}

\item{...}{List of variables or name-value pairs of summary/modifications
functions.}

\item{by}{(Optional) Mutate by what group?}
}
\value{
data.table
}
\description{
Adds or updates columns in data.frame.
}
\examples{

iris \%>\% mutate_dt(one = 1,Sepal.Length = Sepal.Length + 1)
iris \%>\% transmute_dt(one = 1,Sepal.Length = Sepal.Length + 1)
# add group number with symbol `.GRP`
iris \%>\% mutate_dt(id = 1:.N,grp = .GRP,by = Species)

}
\seealso{
\code{\link[dplyr]{mutate}}
}
