% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_when.R
\name{mutate_when}
\alias{mutate_when}
\alias{mutate_vars}
\title{Conditional update of columns in data.table}
\usage{
mutate_when(.data, when, ...)

mutate_vars(.data, .cols = NULL, .func, ..., by)
}
\arguments{
\item{.data}{data.frame}

\item{when}{An object which can be coerced to logical mode}

\item{...}{Name-value pairs of expressions for \code{mutate_when}.
Additional parameters to be passed to parameter '.func' in \code{mutate_vars}.}

\item{.cols}{Any types that can be accepted by \code{\link[tidyfst]{select_dt}}.}

\item{.func}{Function to be run within each column, should return a value or
vectors with same length.}

\item{by}{(Optional) Mutate by what group?}
}
\value{
data.table
}
\description{
\code{mutate_when} integrates \code{mutate} and \code{case_when}
in \pkg{dplyr} and make a new tidy verb for data.table. \code{mutate_vars} is
 a super function to do updates in specific columns according to conditions.
}
\examples{
iris[3:8,]
iris[3:8,] \%>\%
  mutate_when(Petal.Width == .2,
              one = 1,Sepal.Length=2)

iris \%>\% mutate_vars("Pe",scale)
iris \%>\% mutate_vars(is.numeric,scale)
iris \%>\% mutate_vars(-is.factor,scale)
iris \%>\% mutate_vars(1:2,scale)
iris \%>\% mutate_vars(.func = as.character)
}
\seealso{
\code{\link[tidyfst]{select_dt}}, \code{\link[dplyr]{case_when}}
}
