% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_dt.R
\name{count_dt}
\alias{count_dt}
\alias{add_count_dt}
\title{Count observations by group}
\usage{
count_dt(.data, ..., sort = TRUE, .name = "n")

add_count_dt(.data, ..., .name = "n")
}
\arguments{
\item{.data}{data.table/data.frame data.frame will be automatically converted
to data.table.}

\item{...}{variables to group by.}

\item{sort}{logical. If TRUE result will be sorted in desending order by resulting variable.}

\item{.name}{character. Name of resulting variable. Default uses "n".}
}
\value{
data.table
}
\description{
Analogous function for \code{count} and \code{add_count} in \pkg{dplyr}.
}
\examples{
iris \%>\% count_dt(Species)
iris \%>\% count_dt(Species,.name = "count")
iris \%>\% add_count_dt(Species)
iris \%>\% add_count_dt(Species,.name = "N")

mtcars \%>\% count_dt(cyl,vs)
mtcars \%>\% add_count_dt(cyl,vs)

}
\seealso{
\code{\link[dplyr]{count}}
}
