% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_dt.R
\name{left_join_dt}
\alias{left_join_dt}
\alias{right_join_dt}
\alias{inner_join_dt}
\alias{full_join_dt}
\alias{anti_join_dt}
\alias{semi_join_dt}
\title{Join table by common keys}
\usage{
left_join_dt(x, y, by = NULL, suffix = c(".x", ".y"))

right_join_dt(x, y, by = NULL, suffix = c(".x", ".y"))

inner_join_dt(x, y, by = NULL, suffix = c(".x", ".y"))

full_join_dt(x, y, by = NULL, suffix = c(".x", ".y"))

anti_join_dt(x, y, by = NULL)

semi_join_dt(x, y, by = NULL)
}
\arguments{
\item{x}{data.frame}

\item{y}{data.frame}

\item{by}{a character vector of variables to join by. If NULL, the default,
*_join() will do a natural join, using all variables with common names
across the two tables. A message lists the variables so that you can check
they're right (to suppress the message, simply explicitly list the
variables that you want to join). To join by different variables on x and y
use a named vector. For example, by = c("a" = "b") will match x.a to y.b.}

\item{suffix}{If there are non-joined duplicate variables in x and y, these
suffixes will be added to the output to disambiguate them. Should be a
character vector of length 2.}
}
\value{
data.table
}
\description{
Join operations.
}
\examples{

workers = fread("
    name company
    Nick Acme
    John Ajax
    Daniela Ajax
")

positions = fread("
    name position
    John designer
    Daniela engineer
    Cathie manager
")

workers \%>\% inner_join_dt(positions)
workers \%>\% left_join_dt(positions)
workers \%>\% right_join_dt(positions)
workers \%>\% full_join_dt(positions)

# filtering joins
workers \%>\% anti_join_dt(positions)
workers \%>\% semi_join_dt(positions)

# To suppress the message, supply 'by' argument
workers \%>\% left_join_dt(positions, by = "name")

# Use a named 'by' if the join variables have different names
positions2 = setNames(positions, c("worker", "position")) # rename first column in 'positions'
workers \%>\% inner_join_dt(positions2, by = c("name" = "worker"))
}
\seealso{
\code{\link[dplyr]{left_join}}
}
