% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m.R
\name{m}
\alias{m}
\title{Generic model wrapper for \code{tidyfit}}
\usage{
m(model_method, formula = NULL, data = NULL, ...)
}
\arguments{
\item{model_method}{The name of the method to fit. See Details.}

\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}

\item{...}{Additional arguments passed to the underlying method function (e.g. \code{lm} or \code{glm}).}
}
\value{
A 'tidyfit.models' data frame.
}
\description{
The function can fit various regression or classification models and returns the results as a tibble. \code{m()} can be used in conjunction with \code{\link{regress}} and \code{\link{classify}}, or as a stand-alone function.
}
\details{
\code{model_method} specifies the model to fit to the data and can take one of several options:
\subsection{Linear (generalized) regression or classification}{

\code{"lm"} performs an OLS regression using \code{stats::lm}. See \code{\link{.fit.lm}} for details.

\code{"glm"} performs a generalized regression or classification using \code{stats::glm}. See \code{\link{.fit.glm}} for details.

\code{"anova"} performs analysis of variance using \code{stats::anova}. See \code{\link{.fit.anova}} for details.

\code{"robust"} performs a robust regression using \code{MASS::rlm}. See \code{\link{.fit.robust}} for details.

\code{"quantile"} performs a quantile regression using \code{quantreg::rq}. See \code{\link{.fit.quantile}} for details.
}

\subsection{Regression and classification with L1 and L2 penalties}{

\code{"lasso"} performs a linear regression or classification with L1 penalty using \code{glmnet::glmnet}. See \code{\link{.fit.lasso}} for details.

\code{"ridge"} performs a linear regression or classification with L2 penalty using \code{glmnet::glmnet}. See \code{\link{.fit.ridge}} for details.

\code{"adalasso"} performs an Adaptive Lasso regression or classification using \code{glmnet::glmnet}. See \code{\link{.fit.adalasso}} for details.

\code{"enet"} performs a linear regression or classification with L1 and L2 penalties using \code{glmnet::glmnet}. See \code{\link{.fit.enet}} for details.

\code{"group_lasso"} performs a linear regression or classification with grouped L1 penalty using \code{gglasso::gglasso}. See \code{\link{.fit.group_lasso}} for details.
}

\subsection{Other Machine Learning}{

\code{"boost"} performs gradient boosting regression or classification using \code{mboost::glmboost}. See \code{\link{.fit.boost}} for details.

\code{"rf"} performs a random forest regression or classification using \code{randomForest::randomForest}. See \code{\link{.fit.rf}} for details.

\code{"quantile_rf"} performs a quantile random forest regression or classification using \code{quantregForest::quantregForest}. See \code{\link{.fit.quantile_rf}} for details.

\code{"svm"} performs a support vector regression or classification using \code{e1071::svm}. See \code{\link{.fit.svm}} for details.

\code{"nnet"} performs a neural network regression or classification using \code{nnet::nnet}. See \code{\link{.fit.nnet}} for details.
}

\subsection{Factor regressions}{

\code{"pcr"} performs a principal components regression using \code{pls::pcr}. See \code{\link{.fit.pcr}} for details.

\code{"plsr"} performs a partial least squares regression using \code{pls::plsr}. See \code{\link{.fit.plsr}} for details.

\code{"hfr"} performs a hierarchical feature regression using \code{hfr::hfr}. See \code{\link{.fit.hfr}} for details.
}

\subsection{Best subset selection}{

\code{"subset"} performs a best subset regression or classification using \code{bestglm::bestglm} (wrapper for \code{leaps}). See \code{\link{.fit.subset}} for details.

\code{"gets"} performs a general-to-specific regression using \code{gets::gets}. See \code{\link{.fit.gets}} for details.
}

\subsection{Bayesian methods}{

\code{"bayes"} performs a Bayesian generalized regression or classification using \code{arm::bayesglm}. See \code{\link{.fit.bayes}} for details.

\code{"bridge"} performs a Bayesian ridge regression using \code{monomvn::bridge}. See \code{\link{.fit.bridge}} for details.

\code{"blasso"} performs a Bayesian Lasso regression using \code{monomvn::blasso}. See \code{\link{.fit.blasso}} for details.

\code{"spikeslab"} performs a Bayesian Spike and Slab regression using \code{BoomSpikeSlab::lm.spike}. See \code{\link{.fit.spikeslab}} for details.

\code{"bma"} performs a Bayesian model averaging regression using \code{BMS::bms}. See \code{\link{.fit.bma}} for details.

\code{"tvp"} performs a Bayesian time-varying parameter regression using \code{shrinkTVP::shrinkTVP}. See \code{\link{.fit.tvp}} for details.
}

\subsection{Mixed-effects modeling}{

\code{"glmm"} performs a mixed-effects GLM using \code{lme4::glmer}. See \code{\link{.fit.glmm}} for details.
}

\subsection{Specialized time series methods}{

\code{"mslm"} performs a Markov-switching regression using \code{MSwM::msmFit}. See \code{\link{.fit.mslm}} for details.
}

\subsection{Feature selection}{

\code{"cor"} calculates Pearson's correlation coefficient using \code{stats::cor.test}. See \code{\link{.fit.cor}} for details.

\code{"chisq"} calculates Pearson's Chi-squared test using \code{stats::chisq.test}. See \code{\link{.fit.chisq}} for details.

\code{"mrmr"} performs a minimum redundancy, maximum relevance features selection routine using \code{mRMRe::mRMR.ensemble}. See \code{\link{.fit.mrmr}} for details.

\code{"relief"} performs a ReliefF feature selection routine using \code{CORElearn::attrEval}. See \code{\link{.fit.relief}} for details.

\code{"genetic"} performs a linear regression with feature selection using the genetic algorithm implemented in \code{gaselect::genAlg}. See \code{\link{.fit.genetic}} for details.

When called without \code{formula} and \code{data} arguments, the function returns a 'tidyfit.models' data frame with unfitted models.
}
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("lm", Return ~ ., data)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("lm"), .mask = "Date")
fit

}
\seealso{
\code{\link{regress}} and \code{\link{classify}} methods
}
\author{
Johann Pfitzinger
}
