% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_common_genes.R
\name{filter_common_genes}
\alias{filter_common_genes}
\title{Remove non-common genes from data frame}
\usage{
filter_common_genes(
  df,
  id = c("entrezgene_id", "hgnc_symbol"),
  tidy = FALSE,
  tell_missing = TRUE,
  find_alias = FALSE
)
}
\arguments{
\item{df}{a \code{data.frame} of RNA expression values, with columns corresponding
to samples, and rows corresponding to genes. Either rownames or the first
column can contain gene IDs (see \code{tidy})}

\item{id}{either \code{"entrezgene_id"} or \code{"hgnc_symbol"}, whichever
\code{df} contains.}

\item{tidy}{logical. If rownames contain gene identifier, set \code{FALSE}.
If first column contains gene identifier, set \code{TRUE}}

\item{tell_missing}{logical. If \code{TRUE}, prints message of genes in
common gene set that are not in supplied data frame.}

\item{find_alias}{logical. If \code{TRUE} and \code{id = "hgnc_symbol"}, will
attempt to find if genes missing from \code{common_genes} are going under
an alias. See details for more information.}
}
\value{
A \code{tibble}, with gene identifiers as the first column
}
\description{
As ESTIMATE score calculation is sensitive to the number of genes used, a set
of common genes used between six platforms has been established (see
\code{?tidyestimate::common_genes}). This function will filter for only those
genes.
}
\details{
The \code{find_aliases} argument will attempt to find aliases for HGNC
symbols in \code{tidyestimate::common_genes} but missing from the provided
dataset. This will only run if \code{find_aliases = TRUE} and \code{id =
"hgnc_symbol"}.

This algorithm is very conservative: It will only make a match if the gene
from the common genes has only one alias that matches with only one gene from
the provided dataset, \emph{and} the gene from the provided dataset with
which it matches only matches with a single gene from the list of common
genes. (Note that a single gene may have many aliases). Once a match has been
made, the gene in the provided dataset is updated to the gene name in the
common gene list.

While this method is fairly accurate, is is also a heuristic. Therefore, it is
disabled by default. Users should check which genes are becoming reassigned
to ensure accuracy.

The method of generation of these aliases can be found at
\code{?tidyestimate::common_genes}
}
\examples{
filter_common_genes(ov, id = "hgnc_symbol", tidy = FALSE, tell_missing = TRUE, find_alias = FALSE)
}
