# tidycountries  R Package

The `tidycountries` package provides a comprehensive and user-friendly interface for accessing, manipulating, and analyzing country-level data from around the world. It allows users to retrieve detailed information on countries, including names, regions, subregions, continents, populations, currencies, calling codes, and more, all in a tidy data format. The package is designed to work seamlessly within the tidyverse ecosystem, making it easy to filter, arrange, and visualize country-level data in R.


## Why tidycountries: 
The world is a diverse and complex place, and having reliable and accessible country-level data is crucial for many analyses. Whether you're working on a global research project, developing a visualization, or simply need to query country data for your application, `tidycountries` aims to simplify these tasks. By providing country data in a tidy format compatible with the `tidyverse` ecosystem, `tidycountries` allows users to seamlessly integrate and manipulate country data.


## Installation
You can install the `tidycountries` package from CRAN using the following command:

```
install.packages("tidycountries")

# you can also install the package directly using `devtools`
devtools::install_github("denironyx/tidycountries")
```

### Loading the Package
Once installed, you need to load the package to use its function

```
library(tidyverse)
library(tidycountries)
```
