% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{dummify_scale}
\alias{dummify_scale}
\title{Convert categorical variables to dummy variables}
\usage{
dummify_scale(data, ..., overwrite = FALSE)
}
\arguments{
\item{data}{A \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model.}

\item{...}{Categorical variables to be transformed into dummy variables.
Category names will be automatically appended to the newly created dummy variables.}

\item{overwrite}{Logical. If \code{TRUE}, it overwrites the original variable(s)
with the dummy variables. If \code{FALSE} (default), new variables are created.}
}
\value{
A \link{tdcmm} model with the dummy variables appended.
}
\description{
This function transforms specified categorical variables into dummy variables.
Each level of the categorical variable is represented by a new dummy variable.
Missing values are retained.
These new dummy variables are appended to the original data frame. This function
does not allow specifying new column names for the dummy variables. Instead, it
follows a consistent naming pattern: the new dummy variables are named using the
original variable name with the category value appended. For example, if a
categorical variable named "autonomy" with levels "low", "medium", "high" is dummified,
the new dummy variables will be named "autonomy_low", "autonomy_medium", "autonomy_high".
}
\examples{
WoJ \%>\% dplyr::select(temp_contract) \%>\% dummify_scale(temp_contract)
WoJ \%>\% categorize_scale(autonomy_emphasis, breaks = c(2, 3),
labels = c('low', 'medium', 'high')) \%>\%
dummify_scale(autonomy_emphasis_cat) \%>\% dplyr::select(starts_with('autonomy_emphasis'))
}
\seealso{
Other scaling: 
\code{\link{categorize_scale}()},
\code{\link{center_scale}()},
\code{\link{minmax_scale}()},
\code{\link{recode_cat_scale}()},
\code{\link{reverse_scale}()},
\code{\link{setna_scale}()},
\code{\link{z_scale}()}
}
\concept{scaling}
