% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlate}
\alias{correlate}
\title{Compute correlation coefficients}
\usage{
correlate(data, ..., method = "pearson")
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble}}

\item{...}{Variables to compute correlations for (column names). Leave empty
to compute for all numeric variables in data.}

\item{method}{a character string indicating which correlation coefficient
is to be computed. One of "pearson" (default), "kendall", or "spearman"}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Computes correlation coefficients for all combinations of the specified
variables. If no variables are specified, all numeric (integer or double)
variables are used.
}
\examples{
WoJ \%>\% correlate(ethics_1, ethics_2, ethics_3)
WoJ \%>\% correlate()

}
\concept{correlations}
