% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_cuminc.R
\name{tbl_cuminc}
\alias{tbl_cuminc}
\alias{tbl_cuminc.tidycuminc}
\title{Tabular Summary of Cumulative Incidence}
\usage{
\method{tbl_cuminc}{tidycuminc}(
  x,
  times = NULL,
  outcomes = NULL,
  statistic = "{estimate}\% ({conf.low}\%, {conf.high}\%)",
  label = NULL,
  label_header = "**Time {time}**",
  estimate_fun = NULL,
  conf.level = x$conf.level,
  missing = NULL,
  ...
)

tbl_cuminc(x, ...)
}
\arguments{
\item{x}{a 'tidycuminc' object created with \code{cuminc()}}

\item{times}{Numeric vector of times to obtain risk estimates at}

\item{outcomes}{character vector of outcomes to include. Default
is to include the first outcome.}

\item{statistic}{string of statistic to report. Default is
\code{"{estimate}\% ({conf.low}\%, {conf.high}\%)"}}

\item{label}{string indicating the variable label}

\item{label_header}{string for the header labels; uses glue syntax.
Default is \code{"**Time {time}**"}}

\item{estimate_fun}{function that styles and formats the statistics.
Default is \code{~gtsummary::style_sigfig(.x, scale = 100)}}

\item{conf.level}{Level of the confidence interval. Default matches that in
\code{cuminc(conf.level=)} (typically, 0.95)}

\item{missing}{string to replace missing values with. Default is an
em-dash, \code{"\\U2014"}}

\item{...}{not used}
}
\description{
\emph{This is experimental and breaking changes may be made in a future release.}
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_cuminc_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_cuminc_ex2.png}{options: width=60\%}}
}

\examples{
# Example 1 ----------------------------------
tbl_cuminc_ex1 <-
  cuminc(Surv(ttdeath, death_cr) ~ 1, trial) \%>\%
  tbl_cuminc(times = c(12, 24), label_header = "**Month {time}**")

# Example 2 ----------------------------------
tbl_cuminc_ex2 <-
  cuminc(Surv(ttdeath, death_cr) ~ trt, trial) \%>\%
  tbl_cuminc(times = c(12, 24),
             outcomes = c("death from cancer", "death other causes"),
             label_header = "**Month {time}**")

}
\seealso{
Other tbl_cuminc tools: 
\code{\link{add_cuminc}}
}
\concept{tbl_cuminc tools}
