% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_clust.R, R/k_means.R, R/update.R
\name{update.hier_clust}
\alias{update.hier_clust}
\alias{update.k_means}
\alias{tidyclust_update}
\title{Update a cluster specification}
\usage{
\method{update}{hier_clust}(
  object,
  parameters = NULL,
  num_clusters = NULL,
  cut_height = NULL,
  linkage_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{k_means}(object, parameters = NULL, num_clusters = NULL, fresh = FALSE, ...)
}
\arguments{
\item{object}{A cluster specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main} parameters to
update. Use \strong{either} \code{parameters} \strong{or} the main arguments directly when
updating. If the main arguments are used, these will supersede the values
in \code{parameters}. Also, using engine arguments in this object will result in
an error.}

\item{num_clusters}{Positive integer, number of clusters in model.}

\item{cut_height}{Positive double, height at which to cut dendrogram to
obtain cluster assignments (only used if \code{num_clusters} is \code{NULL})}

\item{linkage_method}{the agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC).}

\item{fresh}{A logical for whether the arguments should be modified in-place
or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\value{
An updated cluster specification.
}
\description{
If parameters of a cluster specification need to be modified,
\code{update()} can be used in lieu of recreating the object from scratch.
}
\examples{
kmeans_spec <- k_means(num_clusters = 5)
kmeans_spec
update(kmeans_spec, num_clusters = 1)
update(kmeans_spec, num_clusters = 1, fresh = TRUE)

param_values <- tibble::tibble(num_clusters = 10)

kmeans_spec \%>\% update(param_values)
}
