% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_meanvar.R
\name{fit_meanvar}
\alias{fit_meanvar}
\title{Fit a model for mean and variance}
\usage{
fit_meanvar(x, tau, ...)
}
\arguments{
\item{x}{A time series}

\item{tau}{a set of indices representing a changepoint set}

\item{...}{currently ignored}
}
\value{
A \link{mod_cpt} object.
}
\description{
Fit a model for mean and variance
}
\details{
In a mean-variance model, both the means and variances are allowed to vary
across regions.
Thus, this model fits a separate \eqn{\mu_j} and \eqn{\sigma_j} for each
region \eqn{j}.
}
\examples{
# Fit a mean-variance model
fit_meanvar(CET, tau = c(42, 330))

}
\seealso{
\code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}}

Other model-fitting: 
\code{\link{fit_lmshift}()},
\code{\link{fit_meanshift}()},
\code{\link{fit_nhpp}()},
\code{\link{model_args}()},
\code{\link{model_name}()},
\code{\link{new_fun_cpt}()},
\code{\link{whomademe}()}
}
\concept{model-fitting}
