% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_lmshift.R
\name{fit_lmshift}
\alias{fit_lmshift}
\alias{fit_lmshift_ar1}
\alias{fit_trendshift}
\alias{fit_trendshift_ar1}
\title{Regression-based model fitting}
\usage{
fit_lmshift(x, tau, deg_poly = 0, ...)

fit_lmshift_ar1(x, tau, ...)

fit_trendshift(x, tau, ...)

fit_trendshift_ar1(x, tau, ...)
}
\arguments{
\item{x}{A time series}

\item{tau}{a set of indices representing a changepoint set}

\item{deg_poly}{integer indicating the degree of the polynomial spline to be
fit. Passed to \code{\link[stats:poly]{stats::poly()}}.}

\item{...}{arguments passed to \code{\link[stats:lm]{stats::lm()}}}
}
\value{
A \link{mod_cpt} object
}
\description{
Regression-based model fitting
}
\details{
These model-fitting functions use \code{\link[stats:lm]{stats::lm()}} to fit the corresponding
regression model to a time series, using the changepoints specified by the
\code{tau} argument.
Each changepoint is treated as a categorical fixed-effect, while the \code{deg_poly}
argument controls the degree of the polynomial that interacts with those
fixed-effects.
For example, setting \code{deg_poly} equal to 0 will return the same model as
calling \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}}, but the latter is faster for larger changepoint
sets because it doesn't have to fit all of the regression models.

Setting \code{deg_poly} equal to 1 fits the \code{trendshift} model.

\itemize{
\item \code{\link[=fit_lmshift_ar1]{fit_lmshift_ar1()}}: will apply auto-regressive lag 1 errors
}

\itemize{
\item \code{\link[=fit_trendshift]{fit_trendshift()}}: will fit a line in each region
}

\itemize{
\item \code{\link[=fit_trendshift_ar1]{fit_trendshift_ar1()}}: will fit a line in each region and autoregress lag 1 errors
}
}
\examples{
# Manually specify a changepoint set
tau <- c(365, 826)

# Fit the model
mod <- fit_lmshift(DataCPSim, tau)

# Retrieve model parameters
logLik(mod)
deg_free(mod)

# Manually specify a changepoint set
cpts <- c(1700, 1739, 1988)
ids <- time2tau(cpts, as_year(time(CET)))

# Fit the model
mod <- fit_lmshift(CET, tau = ids)

# View model parameters
glance(mod)
glance(fit_lmshift(CET, tau = ids, deg_poly = 1))
glance(fit_lmshift_ar1(CET, tau = ids))
glance(fit_lmshift_ar1(CET, tau = ids, deg_poly = 1))
glance(fit_lmshift_ar1(CET, tau = ids, deg_poly = 2))

# Empty changepoint sets are allowed
fit_lmshift(CET, tau = NULL)

# Duplicate changepoints are removed
fit_lmshift(CET, tau = c(42, 42))

}
\seealso{
Other model-fitting: 
\code{\link{fit_meanshift}()},
\code{\link{fit_meanvar}()},
\code{\link{fit_nhpp}()},
\code{\link{model_args}()},
\code{\link{model_name}()},
\code{\link{new_fun_cpt}()},
\code{\link{whomademe}()}
}
\concept{model-fitting}
