% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax-create_scales.R
\name{create_scales}
\alias{create_scales}
\alias{create_scales.tidy_sem}
\title{Create scale scores from observed variables}
\usage{
create_scales(
  x,
  keys.list,
  missing = TRUE,
  impute = "none",
  omega = NULL,
  digits = 2,
  ...
)

\method{create_scales}{tidy_sem}(
  x,
  keys.list,
  missing = TRUE,
  impute = "none",
  omega = NULL,
  digits = 2,
  ...
)
}
\arguments{
\item{x}{A \code{data.frame} containing all variables referenced in the
\code{keys.list}, or an object of class \code{tidy_sem}.}

\item{keys.list}{A named list, indicating which variables belong to which
scale.}

\item{missing}{Whether to use rows with partially missing values.
Default: TRUE.}

\item{impute}{Method for handling missing values, Default: 'none'. This
default method uses all available data to calculate scale scores, which is
acceptable for mean scales, but not for sum scales.}

\item{omega}{Which of McDonald's \code{\link[psych]{omega}} coefficients to
report. Default: NULL; valid options include: \code{"omega_h"},
\code{"omega.lim"}, \code{"alpha"}, \code{"omega.tot"}, \code{"G6"}.}

\item{digits}{Number of digits for rounding, Default: 2}

\item{...}{Additional parameters to pass to and from functions.}
}
\value{
List with elements: \code{$descriptives}, \code{$correlations}, and
\code{$scores}.
}
\description{
This function calculates mean or sum scores from a
\code{data.frame} and a named list describing the items in each scale. It
returns the scores, a scale descriptive table, and a scale correlation table.
It relies on several functions from the
\code{psych} package.
}
\details{
For scales with less than 3 items, Cronbach's alpha might not be
suitable as an estimate of reliability. For such scales, the Spearman-Brown
reliability coefficient for two-item scales is computed, as described in
Eisinga, R., Grotenhuis, M. te, & Pelzer, B. (2012). The reliability of a
two-item scale: Pearson, Cronbach, or Spearman-Brown? International Journal
of Public Health, 58(4), 637–642. <doi:10.1007/s00038-012-0416-3>.
These coefficients are marked with "(sb)".
}
\examples{
out <- create_scales(iris, keys.list = list(scalename =
            c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")))
out$descriptives
dict <- tidy_sem(iris, split = "\\\\.")
create_scales(dict)
}
