% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyfeed.R
\name{tidyfeed}
\alias{tidyfeed}
\title{Extract a tidy data frame from RSS and Atom and JSON feeds}
\usage{
tidyfeed(feed, sf = TRUE)
}
\arguments{
\item{feed}{(\code{character}). The url for the feed that you want to parse.}

\item{sf}{(\code{logical}). By default, \code{tidyfeed()} returns a simple
features dataframe from georss feeds. This behaviour can be changed by setting
\code{sf = FALSE}, which will return a dataframe that includes a column for
latitude and a column for longitude.}
}
\description{
\code{tidyfeed()} downloads and parses rss feeds. The function
produces a tidy data frame, easy to use for further manipulation and
analysis.
}
\examples{
\dontrun{
# Atom feed:
tidyfeed("http://journal.r-project.org/rss.atom")
# rss/xml:
tidyfeed("http://fivethirtyeight.com/all/feed")
# jsonfeed:
tidyfeed("https://daringfireball.net/feeds/json")
# georss:
tidyfeed("http://www.geonames.org/recent-changes.xml")
}
}
\references{
\url{https://en.wikipedia.org/wiki/RSS}
}
\author{
Robert Myles McDonnell, \email{robertmylesmcdonnell@gmail.com}
}
