% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{Stack and StackList}
\alias{Stack and StackList}
\alias{push}
\alias{Stack}
\alias{StackList}
\alias{push.default}
\alias{pop.default}
\alias{clear.default}
\alias{shift.default}
\alias{first_element.default}
\alias{last_element.default}
\alias{size.default}
\alias{as.Stack.default}
\alias{as.StackList.default}
\alias{pop}
\alias{clear}
\alias{shift}
\alias{first_element}
\alias{last_element}
\alias{size}
\alias{as.Stack}
\alias{as.StackList}
\title{Stack and StackList classes and methods}
\usage{
push(x, value)

pop(x)

clear(x)

shift(x)

first_element(x)

last_element(x)

size(x)

as.Stack(s)

as.StackList(s)

Stack()

StackList()
}
\arguments{
\item{x}{A Stack or StackList object.}

\item{value}{Value to append.}

\item{s}{A structure to be converted to a Stack or StackList.}
}
\description{
\code{push} - Append an element.

\code{pop} - Remove and return the last element.

\code{clear} - Remove all elements.

\code{shift} - Remove and return the first element.

\code{first_element} - Return the first element. We can't use \code{first} because
it's taken by the \code{dplyr} package and is not an S3 method.

\code{last_element} - Return the last element. We can't use \code{last} because
it's taken by the \code{dplyr} package and is not an S3 method.

\code{size} - Return the number of  elements.

\code{as.Stack} - Creates a new Stack from (typically, vector) \code{s}.

\code{as.StackList} - Creates a new StackList from (typically, list) \code{s}.

\code{Stack()} - Creates and keeps a stack of items of the same type, implemented as an R vector.
The type is determined by the first \code{push} operation.

\code{StackList()} - Creates and keeps a list of items of the same type, implemented as an R list.
The type is determined by the first \code{push} operation.
}
