% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_barbs.R
\name{sounding_barbs}
\alias{sounding_barbs}
\title{Plot wind profile using wind barbs}
\usage{
sounding_barbs(
  pressure,
  ws,
  wd,
  altitude,
  ptop = 100,
  interpolate = TRUE,
  showaxis = FALSE,
  barb_cex = 0.3,
  ...
)
}
\arguments{
\item{pressure}{pressure [hPa]}

\item{ws}{wind speed [knots]}

\item{wd}{wind direction [azimuth in degrees]}

\item{altitude}{altitude [m] (can be above sea level or above ground level as function always consider first level as surface, i.e h = 0 m) - altitude [m]}

\item{ptop}{Pressure top level to be used for plotting wind speed. Valid options should be < 200 hPa (100 by default)}

\item{interpolate}{logical, draw wind barbs only at interpolated altitudes with 500 m interval (default = TRUE)  instead of all wind barbs for a given input dataset}

\item{showaxis}{logical, drawing bounding box with left axis for pressure heighs (default FALSE)}

\item{barb_cex}{size of wind barbs (default = 0.3)}

\item{...}{extra graphic arguments}
}
\value{
wind barbs plot for a given vertical profile of atmosphere
}
\description{
Function for plotting wind direction and wind speed profile with the use of wind barbs.
Can be launched as standalone function or coupled with pre-drawn Skew-T diagram.
}
\examples{
# load examplary dataset:
data("sounding_vienna")
attach(sounding_vienna)
sounding_barbs(pressure = pressure, ws = ws, wd = wd, altitude = altitude,
              interpolate = TRUE, showaxis = TRUE)

}
