% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshr.R
\docType{package}
\name{threshr}
\alias{threshr}
\alias{threshr-package}
\title{threshr: Threshold Selection and Uncertainty for Extreme Value Analysis}
\description{
Provides functions for the selection of extreme value threshold.
At the moment only the simplest case, where the data can be treated as
independent identically distributed observations, is considered.
Future releases will tackle more general situations.
See the 'threshr' website for more information, documentation
and examples.
}
\details{
The main function in the threshr package is \code{\link{ithresh}},
  which uses leave-one-out cross-validation in a Bayesian setup to compare
  the predictive ability resulting from the use of each of a user-supplied
  set of thresholds.

  See \code{vignette("threshr-vignette", package = "threshr")} for an
  overview of the package.
}
\references{
Northrop, P. J. (2017). revdbayes: Ratio-of-Uniforms Sampling
  for Bayesian Extreme Value Analysis. R package version 1.2.1.
  \url{https://cran.r-project.org/package=revdbayes}.

Northrop, P. J., Attalides, N. and Jonathan, P. (2017)
  Cross-validatory extreme value threshold selection and uncertainty
  with application to ocean storm severity.
  \emph{Journal of the Royal Statistical Society Series C: Applied
  Statistics}, \strong{66}(1), 93-120.
  \url{http://dx.doi.org/10.1111/rssc.12159}
}
\seealso{
The packages \code{\link[revdbayes]{revdbayes}} and
  \code{\link[rust]{rust}}.

\code{\link{ithresh}} for threshold selection in the i.i.d. case
  based on leave-one-out cross-validation.
}
